﻿//////////////////////////////////////////////
// KeyboardDeviceManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkInputs
{
	class System ;
}

/// Includes ---------------------------------

// nkInputs
#include "../../Dll/DllDefines.h"

#include "KeyboardDevice.h"

// nkCommon
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <unordered_map>
#include <string>

/// Class ------------------------------------

namespace nkInputs
{
	class DLL_INPUTS_EXPORT KeyboardDeviceManager final : public nkCommon::MaybeSingletonClass<KeyboardDeviceManager>
	{
		public :

			// Getters
			System* getSystem () const ;

			// Memory management
			KeyboardDevice* createOrRetrieve (nkMemory::StringView name) ;
			KeyboardDevice* record (nkMemory::StringView name, nkMemory::UniquePtr<KeyboardDevice> device) ;
			KeyboardDevice* get (nkMemory::StringView name) const ;
			KeyboardDevice* getByIndex (unsigned int index) const ;
			void rename (nkMemory::StringView currentName, nkMemory::StringView newName) ;
			void erase (nkMemory::StringView name) ;
			nkMemory::UniquePtr<KeyboardDevice> relinquish (nkMemory::StringView name) ;

		private :

			// Functions
			// Constructor
			KeyboardDeviceManager (bool isSingleton) noexcept ;
			KeyboardDeviceManager (System* system) noexcept ;
			KeyboardDeviceManager (const KeyboardDeviceManager&) = delete ;

			// Operators
			KeyboardDeviceManager& operator= (const KeyboardDeviceManager&) = delete ;

		private :

			// Attributes
			// Memory
			std::unordered_map<std::string, nkMemory::UniquePtr<KeyboardDevice>> _devices ;
			System* _system ;

		private :

			friend class nkCommon::MaybeSingletonClass<KeyboardDeviceManager> ;
			friend class System ;
	} ;
}